/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging.gui;

import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.gui.AclGui;
import jade.gui.AgentTree;
import jade.lang.acl.ACLMessage;
import jade.tools.logging.JavaLoggingLogManagerImpl;
import jade.tools.logging.LogManager;
import jade.tools.logging.gui.ContainerLogWindow;
import jade.tools.logging.gui.ExitAction;
import jade.tools.logging.gui.SetDefaultLoggingSystemAction;
import jade.tools.logging.gui.StartManagingLogAction;
import jade.tools.logging.gui.StopManagingLogAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class LogManagerGUI
extends JFrame {
    private static final String DEFAULT_LOG_MANAGER_CLASS = "jade.tools.logging.JavaLoggingLogManagerImpl";
    private Agent myAgent;
    private AgentTree agentTree;
    private JDesktopPane desktopPane;
    private JSplitPane jsp;
    private AbstractAction startManagingLogAction;
    private AbstractAction stopManagingLogAction;
    private AbstractAction setDefaultLoggingSystemAction;
    private AbstractAction exitAction;
    private Map managedContainers = new HashMap();
    private LogManager defaultLogManager;

    public LogManagerGUI(Agent a) {
        super(a.getName());
        this.myAgent = a;
        this.setIconImage(this.getToolkit().getImage(this.getClass().getResource("/jade/gui/images/logger.gif")));
        this.setTitle("JADE Log Manager Agent (" + this.myAgent.getLocalName() + ")");
        this.startManagingLogAction = new StartManagingLogAction(this);
        this.stopManagingLogAction = new StopManagingLogAction(this);
        this.setDefaultLoggingSystemAction = new SetDefaultLoggingSystemAction(this);
        this.exitAction = new ExitAction(this);
        JMenuBar jmb = new JMenuBar();
        JMenu menu = null;
        menu = new JMenu("Settings");
        menu.add(this.setDefaultLoggingSystemAction);
        menu.addSeparator();
        menu.add(this.exitAction);
        jmb.add(menu);
        menu = new JMenu("Logs");
        menu.add(this.startManagingLogAction);
        menu.add(this.stopManagingLogAction);
        jmb.add(menu);
        this.setJMenuBar(jmb);
        JToolBar bar = new JToolBar();
        URL url = null;
        Dimension d = new Dimension(32, 32);
        JButton startB = new JButton();
        startB.setToolTipText("Start managing log on the selected container");
        startB.setAction(this.startManagingLogAction);
        url = this.getClass().getClassLoader().getResource("jade/tools/logging/gui/images/bullet1.gif");
        startB.setIcon(new ImageIcon(url));
        startB.setText(null);
        startB.setMaximumSize(d);
        startB.setMinimumSize(d);
        startB.setPreferredSize(d);
        JButton stopB = new JButton();
        stopB.setToolTipText("Stop managing log on the selected container");
        stopB.setAction(this.stopManagingLogAction);
        url = this.getClass().getClassLoader().getResource("jade/tools/logging/gui/images/bullet2.gif");
        stopB.setIcon(new ImageIcon(url));
        stopB.setText(null);
        stopB.setMaximumSize(d);
        stopB.setMinimumSize(d);
        stopB.setPreferredSize(d);
        JButton setB = new JButton();
        setB.setToolTipText("Set the default logging system to be managed");
        setB.setAction(this.setDefaultLoggingSystemAction);
        url = this.getClass().getClassLoader().getResource("jade/gui/images/tick_blue.gif");
        setB.setIcon(new ImageIcon(url));
        setB.setText(null);
        setB.setMaximumSize(d);
        setB.setMinimumSize(d);
        setB.setPreferredSize(d);
        bar.add(setB);
        bar.addSeparator();
        bar.add(startB);
        bar.add(stopB);
        this.getContentPane().add((Component)bar, "North");
        Font f = new Font("SanSerif", 0, 14);
        this.setFont(f);
        this.agentTree = new AgentTree(f);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.startManagingLogAction);
        popup.add(this.stopManagingLogAction);
        this.agentTree.setNewPopupMenu("FIPACONTAINER", popup);
        this.agentTree.tree.setSize(new Dimension(300, 600));
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(Color.lightGray);
        this.jsp = new JSplitPane(1, new JScrollPane(this.agentTree.tree), new JScrollPane(this.desktopPane));
        this.jsp.setContinuousLayout(true);
        this.jsp.setDividerLocation(300);
        this.getContentPane().add((Component)this.jsp, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LogManagerGUI.this.exit();
            }
        });
        this.defaultLogManager = new JavaLoggingLogManagerImpl();
    }

    public void showCorrect() {
        this.pack();
        this.setSize(800, 600);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int centerX = (int)screenSize.getWidth() / 2;
        int centerY = (int)screenSize.getHeight() / 2;
        this.setLocation(centerX - this.getWidth() / 2, centerY - this.getHeight() / 2);
        this.setVisible(true);
        this.toFront();
    }

    public void resetTree() {
        Runnable r = new Runnable(){

            public void run() {
                LogManagerGUI.this.agentTree.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void addContainer(final String name, final InetAddress address) {
        Runnable r = new Runnable(){

            public void run() {
                LogManagerGUI.this.agentTree.addContainerNode(name, address);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void removeContainer(final String name) {
        Runnable r = new Runnable(){

            public void run() {
                LogManagerGUI.this.agentTree.removeContainerNode(name);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void refreshLocalPlatformName(final String name) {
        Runnable r = new Runnable(){

            public void run() {
                LogManagerGUI.this.agentTree.refreshLocalPlatformName(name);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    void startManagingLog() {
        block5: {
            AgentTree.Node node = this.agentTree.getSelectedNode();
            if (node == null || !(node instanceof AgentTree.ContainerNode)) break block5;
            String containerName = node.getName();
            System.out.println("Container name = " + containerName);
            ContainerLogWindow window = (ContainerLogWindow)this.managedContainers.get(containerName);
            if (window != null) {
                System.out.println("Window found");
                window.moveToFront();
            } else {
                System.out.println("Window NOT found");
                AID controller = null;
                boolean state = false;
                try {
                    if (!containerName.equals(this.myAgent.here().getName())) {
                        controller = this.createController(containerName);
                    }
                    state = true;
                    window = new ContainerLogWindow(this.myAgent, containerName, controller, this.defaultLogManager, this);
                    window.pack();
                    window.setSize(600, 400);
                    window.setVisible(true);
                    this.managedContainers.put(containerName, window);
                    this.desktopPane.add(window);
                    window.moveToFront();
                }
                catch (FIPAException fe) {
                    String msg = !state ? "Cannot create Log Helper agent on container " + containerName : "Cannot retrieve logging information from container " + containerName;
                    int res = JOptionPane.showConfirmDialog(this, msg + "\nWould you like to see the message?", "WARNING", 0);
                    if (res != 0) break block5;
                    AclGui.showMsgInDialog(fe.getACLMessage(), this);
                }
            }
        }
    }

    void stopManagingLog() {
        String containerName;
        ContainerLogWindow window;
        AgentTree.Node node = this.agentTree.getSelectedNode();
        if (node != null && node instanceof AgentTree.ContainerNode && (window = (ContainerLogWindow)this.managedContainers.remove(containerName = node.getName())) != null) {
            AID controller = window.getController();
            if (controller != null) {
                this.killController(controller);
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    window.dispose();
                }
            });
        }
    }

    void setDefaultLoggingSystem() {
        LogManager lm = this.initializeLogManager();
        if (lm != null) {
            this.defaultLogManager = lm;
        }
    }

    void exit() {
        this.myAgent.doDelete();
    }

    LogManager initializeLogManager() {
        String className = null;
        try {
            className = JOptionPane.showInputDialog(this, (Object)"Insert the fully qualified class name of the LogManager implementation for the desired logging system");
            if (className != null) {
                return (LogManager)Class.forName(className).newInstance();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot create a LogManager of class " + className + " [" + e + "]");
        }
        return null;
    }

    private ACLMessage createAMSRequest() {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(this.myAgent.getAMS());
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology(JADEManagementOntology.getInstance().getName());
        return request;
    }

    private AID createController(String containerName) throws FIPAException {
        ACLMessage request = this.createAMSRequest();
        CreateAgent ca = new CreateAgent();
        String localName = this.myAgent.getLocalName() + "-helper-on-" + containerName;
        ca.setAgentName(localName);
        ca.setClassName("jade.tools.logging.LogHelperAgent");
        ca.addArguments(this.myAgent.getAID());
        ca.setContainer(new ContainerID(containerName, null));
        Action act = new Action();
        act.setActor(this.myAgent.getAMS());
        act.setAction(ca);
        try {
            this.myAgent.getContentManager().fillContent(request, act);
            ACLMessage inform = FIPAService.doFipaRequestClient(this.myAgent, request, 10000L);
            if (inform != null) {
                return new AID(localName, false);
            }
            throw new FIPAException("Response timeout expired");
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void killController(AID controller) {
        ACLMessage request = this.createAMSRequest();
        KillAgent ka = new KillAgent();
        ka.setAgent(controller);
        Action act = new Action();
        act.setActor(this.myAgent.getAMS());
        act.setAction(ka);
        try {
            this.myAgent.getContentManager().fillContent(request, act);
            FIPAService.doFipaRequestClient(this.myAgent, request, 10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

